% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs4_get.R
\name{gs4_get}
\alias{gs4_get}
\title{Get Sheet metadata}
\usage{
gs4_get(ss)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet: its file ID, a URL from
which we can recover the ID, an instance of \code{googlesheets4_spreadsheet}
(returned by \code{\link[=gs4_get]{gs4_get()}}), or a \code{\link[googledrive:dribble]{dribble}}, which
is how googledrive represents Drive files. Processed through
\code{\link[=as_sheets_id]{as_sheets_id()}}.}
}
\value{
A list with S3 class \code{googlesheets4_spreadsheet}, for printing
purposes.
}
\description{
Retrieve spreadsheet-specific metadata, such as details on the individual
(work)sheets or named ranges.
\itemize{
\item \code{gs4_get()} complements \code{\link[googledrive:drive_get]{googledrive::drive_get()}}, which
returns metadata that exists for any file on Drive.
}
}
\examples{
if (gs4_has_token()) {
  gs4_get(gs4_example("mini-gap"))
}
}
\seealso{
Wraps the \code{spreadsheets.get} endpoint:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/get}
}
}
