% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheet_append.R
\name{sheet_append}
\alias{sheet_append}
\title{Append rows to a sheet}
\usage{
sheet_append(ss, data, sheet = 1)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet: its file ID, a URL from
which we can recover the ID, an instance of \code{googlesheets4_spreadsheet}
(returned by \code{\link[=gs4_get]{gs4_get()}}), or a \code{\link[googledrive:dribble]{dribble}}, which
is how googledrive represents Drive files. Processed through
\code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{data}{A data frame.}

\item{sheet}{Sheet to append to, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number.}
}
\value{
The input \code{ss}, as an instance of \code{\link{sheets_id}}
}
\description{
Adds one or more new rows after the last row with data in a (work)sheet,
increasing the row dimension of the sheet if necessary.
}
\examples{
if (gs4_has_token()) {
  # we will recreate the table of "other" deaths from this example Sheet
  (deaths <- gs4_example("deaths") \%>\%
    range_read(range = "other_data", col_types = "????DD"))

  # split the data into 3 pieces, which we will send separately
  deaths_one   <- deaths[ 1:5, ]
  deaths_two   <- deaths[   6, ]
  deaths_three <- deaths[7:10, ]

  # create a Sheet and send the first chunk of data
  ss <- gs4_create("sheet-append-demo", sheets = list(deaths = deaths_one))

  # append a single row
  ss \%>\% sheet_append(deaths_two)

  # append remaining rows
  ss \%>\% sheet_append(deaths_three)

  # read and check against the original
  deaths_replica <- range_read(ss, col_types = "????DD")
  identical(deaths, deaths_replica)

  # clean up
  gs4_find("sheet-append-demo") \%>\%
    googledrive::drive_trash()
}
}
\seealso{
Makes an \code{AppendCellsRequest}:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#AppendCellsRequest}
}

Other write functions: 
\code{\link{gs4_create}()},
\code{\link{gs4_formula}()},
\code{\link{range_delete}()},
\code{\link{range_flood}()},
\code{\link{range_write}()},
\code{\link{sheet_write}()}

Other worksheet functions: 
\code{\link{sheet_add}()},
\code{\link{sheet_copy}()},
\code{\link{sheet_delete}()},
\code{\link{sheet_properties}()},
\code{\link{sheet_relocate}()},
\code{\link{sheet_rename}()},
\code{\link{sheet_resize}()},
\code{\link{sheet_write}()}
}
\concept{worksheet functions}
\concept{write functions}
