% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{gtm_variables_get}
\alias{gtm_variables_get}
\title{List all variables in a workspace}
\usage{
gtm_variables_get(account_id, container_id, workspace_id, variable_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{variable_id}{Variable Id}
}
\description{
This will return a list with the settings of a single variable.
If you want to get the information for all variables, use \code{gtm_variables_list}
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 10
variableId = 100

variable <- gtm_variables_get(accountId, containerId, workspaceId, variableId)

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/variables/get}

Other variable functions: 
\code{\link{gtm_variables_create}()},
\code{\link{gtm_variables_delete}()},
\code{\link{gtm_variables_list}()},
\code{\link{gtm_variables_revert}()},
\code{\link{gtm_variables_update}()}
}
\concept{variable functions}
