// Boost.Geometry

// Copyright (c) 2021, Oracle and/or its affiliates.

// Contributed and/or modified by Vissarion Fysikopoulos, on behalf of Oracle

// Licensed under the Boost Software License version 1.0.
// http://www.boost.org/users/license.html

#ifndef BOOST_GEOMETRY_ALGORITHMS_DETAIL_CLOSEST_POINTS_IMPLEMENTATION_HPP
#define BOOST_GEOMETRY_ALGORITHMS_DETAIL_CLOSEST_POINTS_IMPLEMENTATION_HPP

#include <b/geometry/algorithms/detail/distance/implementation.hpp>
#include <b/geometry/algorithms/detail/closest_points/point_to_geometry.hpp>
#include <b/geometry/algorithms/detail/closest_points/multipoint_to_geometry.hpp>
#include <b/geometry/algorithms/detail/closest_points/linear_to_linear.hpp>
#include <b/geometry/algorithms/detail/closest_points/linear_or_areal_to_areal.hpp>
//#include <b/geometry/algorithms/detail/closest_points/linear_to_box.hpp>
//#include <b/geometry/algorithms/detail/closest_points/geometry_to_segment_or_box.hpp>
#include <b/geometry/algorithms/detail/closest_points/segment_to_segment.hpp>
//#include <b/geometry/algorithms/detail/closest_points/segment_to_box.hpp>
//#include <b/geometry/algorithms/detail/closest_points/box_to_box.hpp>

#include <b/geometry/strategies/closest_points/cartesian.hpp>
#include <b/geometry/strategies/closest_points/geographic.hpp>
#include <b/geometry/strategies/closest_points/spherical.hpp>

#endif // BOOST_GEOMETRY_ALGORITHMS_DETAIL_CLOSEST_POINTS_IMPLEMENTATION_HPP
