//  Copyright John Maddock 2006, 2007, 2012, 2014.
//  Copyright Paul A. Bristow 2006, 2007, 2012

//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

// This file includes *all* the special functions.
// this may be useful if many are used
// - to avoid including each function individually.

#ifndef BOOST_MATH_SPECIAL_FUNCTIONS_HPP
#define BOOST_MATH_SPECIAL_FUNCTIONS_HPP

#include <b/math/special_functions/airy.hpp>
#include <b/math/special_functions/acosh.hpp>
#include <b/math/special_functions/asinh.hpp>
#include <b/math/special_functions/atanh.hpp>
#include <b/math/special_functions/bernoulli.hpp>
#include <b/math/special_functions/bessel.hpp>
#include <b/math/special_functions/bessel_prime.hpp>
#include <b/math/special_functions/beta.hpp>
#include <b/math/special_functions/binomial.hpp>
#include <b/math/special_functions/cbrt.hpp>
#include <b/math/special_functions/cos_pi.hpp>
#include <b/math/special_functions/chebyshev.hpp>
#include <b/math/special_functions/digamma.hpp>
#include <b/math/special_functions/ellint_1.hpp>
#include <b/math/special_functions/ellint_2.hpp>
#include <b/math/special_functions/ellint_3.hpp>
#include <b/math/special_functions/ellint_d.hpp>
#include <b/math/special_functions/jacobi_theta.hpp>
#include <b/math/special_functions/jacobi_zeta.hpp>
#include <b/math/special_functions/heuman_lambda.hpp>
#include <b/math/special_functions/ellint_rc.hpp>
#include <b/math/special_functions/ellint_rd.hpp>
#include <b/math/special_functions/ellint_rf.hpp>
#include <b/math/special_functions/ellint_rj.hpp>
#include <b/math/special_functions/ellint_rg.hpp>
#include <b/math/special_functions/erf.hpp>
#include <b/math/special_functions/expint.hpp>
#include <b/math/special_functions/expm1.hpp>
#include <b/math/special_functions/factorials.hpp>
#include <b/math/special_functions/fpclassify.hpp>
#include <b/math/special_functions/gamma.hpp>
#include <b/math/special_functions/hermite.hpp>
#include <b/math/special_functions/hypot.hpp>
#include <b/math/special_functions/hypergeometric_1F0.hpp>
#include <b/math/special_functions/hypergeometric_0F1.hpp>
#include <b/math/special_functions/hypergeometric_2F0.hpp>
#include <b/math/special_functions/hypergeometric_1F1.hpp>
#include <b/math/special_functions/hypergeometric_pFq.hpp>
#include <b/math/special_functions/jacobi_elliptic.hpp>
#include <b/math/special_functions/laguerre.hpp>
#include <b/math/special_functions/lanczos.hpp>
#include <b/math/special_functions/legendre.hpp>
#include <b/math/special_functions/log1p.hpp>
#include <b/math/special_functions/math_fwd.hpp>
#include <b/math/special_functions/next.hpp>
#include <b/math/special_functions/owens_t.hpp>
#include <b/math/special_functions/polygamma.hpp>
#include <b/math/special_functions/powm1.hpp>
#include <b/math/special_functions/sign.hpp>
#include <b/math/special_functions/sin_pi.hpp>
#include <b/math/special_functions/sinc.hpp>
#include <b/math/special_functions/sinhc.hpp>
#include <b/math/special_functions/spherical_harmonic.hpp>
#include <b/math/special_functions/sqrt1pm1.hpp>
#include <b/math/special_functions/zeta.hpp>
#include <b/math/special_functions/modf.hpp>
#include <b/math/special_functions/round.hpp>
#include <b/math/special_functions/trunc.hpp>
#include <b/math/special_functions/pow.hpp>
#include <b/math/special_functions/next.hpp>
#include <b/math/special_functions/owens_t.hpp>
#include <b/math/special_functions/hankel.hpp>
#include <b/math/special_functions/ulp.hpp>
#include <b/math/special_functions/relative_difference.hpp>
#include <b/math/special_functions/lambert_w.hpp>
#include <b/math/special_functions/gegenbauer.hpp>
#include <b/math/special_functions/jacobi.hpp>
#ifndef BOOST_NO_EXCEPTIONS
#include <b/math/special_functions/legendre_stieltjes.hpp>
#endif
#endif // BOOST_MATH_SPECIAL_FUNCTIONS_HPP
