% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{gcs_list_objects}
\alias{gcs_list_objects}
\title{List objects in a bucket}
\usage{
gcs_list_objects(
  bucket = gcs_get_global_bucket(),
  detail = c("summary", "more", "full"),
  prefix = NULL,
  delimiter = NULL
)
}
\arguments{
\item{bucket}{bucket containing the objects}

\item{detail}{Set level of detail}

\item{prefix}{Filter results to objects whose names begin with this prefix}

\item{delimiter}{Use to list objects like a directory listing.}
}
\value{
A data.frame of the objects
}
\description{
List objects in a bucket
}
\details{
Columns returned by \code{detail} are:

\itemize{
  \item \code{summary} - name, size, updated
  \item \code{more} - as above plus: bucket, contentType, storageClass, timeCreated
  \item \code{full} - as above plus: id, selfLink, generation, metageneration, md5Hash, mediaLink, crc32c, etag
 }

 \code{delimited} returns results in a directory-like mode: items will contain only objects whose names,
    aside from the prefix, do not contain delimiter. In conjunction with the prefix filter,
    the use of the delimiter parameter allows the list method to operate like a directory listing,
    despite the object namespace being flat.
    For example, if delimiter were set to \code{"/"}, then listing objects from a bucket that contains the
    objects \code{"a/b", "a/c", "dddd", "eeee", "e/f"} would return objects \code{"dddd" and "eeee"},
    and prefixes \code{"a/" and "e/"}.
}
\seealso{
Other object functions: 
\code{\link{gcs_compose_objects}()},
\code{\link{gcs_copy_object}()},
\code{\link{gcs_delete_object}()},
\code{\link{gcs_get_object}()},
\code{\link{gcs_metadata_object}()}
}
\concept{object functions}
