% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker.R
\name{cr_deploy_docker}
\alias{cr_deploy_docker}
\alias{cr_deploy_docker_construct}
\title{Deploy a local Dockerfile to be built on ContainerRegistry}
\usage{
cr_deploy_docker(
  local,
  image_name = remote,
  dockerfile = NULL,
  remote = basename(local),
  tag = c("latest", "$BUILD_ID"),
  timeout = 600L,
  bucket = cr_bucket_get(),
  projectId = cr_project_get(),
  launch_browser = interactive(),
  kaniko_cache = TRUE,
  predefinedAcl = "bucketOwnerFullControl",
  pre_steps = NULL,
  post_steps = NULL,
  ...
)

cr_deploy_docker_construct(
  local,
  image_name = remote,
  dockerfile = NULL,
  remote = basename(local),
  tag = c("latest", "$BUILD_ID"),
  timeout = 600L,
  bucket = cr_bucket_get(),
  projectId = cr_project_get(),
  launch_browser = interactive(),
  kaniko_cache = TRUE,
  predefinedAcl = "bucketOwnerFullControl",
  pre_steps = NULL,
  post_steps = NULL,
  ...
)
}
\arguments{
\item{local}{The folder containing the Dockerfile to build}

\item{image_name}{The name of the docker image to be built either full name starting with gcr.io or constructed from the image_name and projectId via \code{gcr.io/{projectId}/{image_name}}}

\item{dockerfile}{An optional Dockerfile built to support the script.  Not needed if "Dockerfile" exists in folder.  If supplied will be copied into deployment folder and called "Dockerfile"}

\item{remote}{The folder on Google Cloud Storage}

\item{tag}{The tag or tags to be attached to the pushed image - can use \code{Build} macros}

\item{timeout}{Amount of time that this build should be allowed to run, to second}

\item{bucket}{The GCS bucket that will be used to deploy code source}

\item{projectId}{The projectId}

\item{launch_browser}{Whether to launch the logs URL in a browser once deployed}

\item{kaniko_cache}{If TRUE will use kaniko cache for Docker builds.}

\item{predefinedAcl}{Access setting for the bucket used in deployed.  Set to "bucketLevel" if using bucket level access}

\item{pre_steps}{Other \link{cr_buildstep} to run before the docker build}

\item{post_steps}{Other \link{cr_buildstep} to run after the docker build}

\item{...}{
  Arguments passed on to \code{\link[=cr_buildstep_docker]{cr_buildstep_docker}}
  \describe{
    \item{\code{image}}{The image tag that will be pushed, starting with gcr.io or created by combining with \code{projectId} if not starting with gcr.io}
    \item{\code{location}}{Where the Dockerfile to build is in relation to \code{dir}}
    \item{\code{build_args}}{additional arguments to pass to \code{docker build},
should be a character vector.}
    \item{\code{push_image}}{if \code{kaniko_cache = FALSE} and
\code{push_image = FALSE}, then the docker image is simply built and not
pushed}
  }}
}
\description{
Build a local Dockerfile in the cloud. See googleCloudRunner website for help how to generate Dockerfiles.  If you want the docker to build on each commit, see also \link{cr_deploy_docker_trigger}
}
\details{
This lets you deploy local folders with Dockerfiles, automating saving the source on Google Cloud Storage.

To deploy builds on git triggers and sources such as GitHub, see the examples of \link{cr_buildstep_docker} or the use cases on the website
}
\note{
`cr_deploy_docker_construct` is a helper function to construct the arguments
needed to deploy the docker, which may be combined with
\code{\link{cr_deploy_r}} to combine Docker and R
}
\examples{
\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_email_set("123456@projectid.iam.gserviceaccount.com")
cr_bucket_set("my-bucket")

b <- cr_deploy_docker(system.file("example/", package = "googleCloudRunner"))
}
}
\seealso{
If you want the docker to build on each commit, see \link{cr_deploy_docker_trigger}

Other Deployment functions: 
\code{\link{cr_deploy_docker_trigger}()},
\code{\link{cr_deploy_packagetests}()},
\code{\link{cr_deploy_pkgdown}()},
\code{\link{cr_deploy_run_website}()},
\code{\link{cr_deploy_run}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
