% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers.R
\name{cr_buildtrigger}
\alias{cr_buildtrigger}
\title{Creates a new `BuildTrigger`.This API is experimental.}
\usage{
cr_buildtrigger(
  build,
  name,
  trigger,
  description = paste("cr_buildtrigger: ", Sys.time()),
  disabled = FALSE,
  substitutions = NULL,
  ignoredFiles = NULL,
  includedFiles = NULL,
  trigger_tags = NULL,
  projectId = cr_project_get()
)
}
\arguments{
\item{build}{The build to trigger created via \link{cr_build_make}, or the file location of the cloudbuild.yaml within the trigger source}

\item{name}{User assigned name of the trigger}

\item{trigger}{The trigger source created via \link{cr_buildtrigger_repo}}

\item{description}{Human-readable description of this trigger}

\item{disabled}{If true, the trigger will never result in a build}

\item{substitutions}{A named list of Build macro variables}

\item{ignoredFiles}{ignored_files and included_files are file glob matches extended with support for "**".}

\item{includedFiles}{If any of the files altered in the commit pass the ignored_files}

\item{trigger_tags}{Tags for the buildtrigger listing}

\item{projectId}{ID of the project for which to configure automatic builds}
}
\description{
Creates a new `BuildTrigger`.This API is experimental.
}
\details{
Any source specified in the build will be overwritten to use the trigger as a source (GitHub or Cloud Source Repositories)
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
cloudbuild <- system.file("cloudbuild/cloudbuild.yaml",
                           package = "googleCloudRunner")
bb <- cr_build_make(cloudbuild)

# repo hosted on GitHub
gh_trigger <- cr_buildtrigger_repo("MarkEdmondson1234/googleCloudRunner")

# repo mirrored to Cloud Source Repositories
cs_trigger <- cr_buildtrigger_repo("github_markedmondson1234_googlecloudrunner",
                                   type = "cloud_source")

\dontrun{
# build with in-line build code
cr_buildtrigger(bb, name = "bt-github-inline", trigger = gh_trigger)

# build with in-line build code using Cloud Source Repository
cr_buildtrigger(bb, name = "bt-github-inline", trigger = cs_trigger)

# build pointing to cloudbuild.yaml within the GitHub repo
cr_buildtrigger("inst/cloudbuild/cloudbuild.yaml",
                 name = "bt-github-file", trigger = gh_trigger)

# build with repo mirror from file
cr_buildtrigger("inst/cloudbuild/cloudbuild.yaml",
                 name = "bt-cs-file", trigger = cs_trigger)
}
}
\seealso{
Other BuildTrigger functions: 
\code{\link{BuildTrigger}()},
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_copy}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_repo}()},
\code{\link{cr_buildtrigger_run}()}
}
\concept{BuildTrigger functions}
