% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_buildemail.R
\name{cr_setup_service}
\alias{cr_setup_service}
\alias{cr_setup_role_lookup}
\title{Give a service account the right permissions for googleCloudRunner operations}
\usage{
cr_setup_service(
  account_email,
  roles = cr_setup_role_lookup("local"),
  json = Sys.getenv("GAR_CLIENT_JSON"),
  email = Sys.getenv("GARGLE_EMAIL")
)

cr_setup_role_lookup(
  type = c("local", "cloudrun", "bigquery", "secrets", "cloudbuild", "cloudstorage")
)
}
\arguments{
\item{account_email}{The service account email e.g. \code{accountId@projectid.iam.gserviceaccount.com} or {12345678@cloudbuild.gserviceaccount.com}}

\item{roles}{the roles to grant access - default is all googleCloudRunner functions}

\item{json}{the project clientId JSON}

\item{email}{the email of an Owner/Editor for the project}

\item{type}{the role}
}
\description{
Give a service account the right permissions for googleCloudRunner operations
}
\seealso{
Other setup functions: 
\code{\link{cr_setup_auth}()},
\code{\link{cr_setup_test}()},
\code{\link{cr_setup}()}
}
\concept{setup functions}
