% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ga_model_edit}
\alias{ga_model_edit}
\title{Edit a created ga_model}
\usage{
ga_model_edit(
  model,
  data_f = NULL,
  required_columns = NULL,
  model_f = NULL,
  required_packages = NULL,
  description = NULL,
  outputShiny = shiny::plotOutput,
  renderShiny = shiny::renderPlot,
  inputShiny = NULL,
  output_f = NULL
)
}
\arguments{
\item{model}{The model to edit - if a filepath will load model and
save back edited model to the same file}

\item{data_f}{A function that gets the data}

\item{required_columns}{What dimensions and metrics are required}

\item{model_f}{A function that inputs data, and outputs a list of assets -
must take data from result of \code{data_f} in first argument}

\item{required_packages}{The packages needed for \code{data_f} and \code{model_f} to work}

\item{description}{An optional description of what the model does}

\item{outputShiny}{A shiny UI output function that will display the results \code{renderShiny}}

\item{renderShiny}{A shiny render function that will create the output for \code{outputShiny} from \code{output_f}}

\item{inputShiny}{Optional input shiny functions (like \code{dateInput()}) that will be used within the model's Shiny module.  The id should be exactly the same as one of the variables in the model functions.}

\item{output_f}{A function that inputs the output from \code{model_f}, outputs a visualisation}
}
\description{
Change features of a model by changing the functions within it.
}
\examples{

\dontrun{

decomp_ga <- ga_model_example("decomp_ga.gamr")
decomp_ga

# edit its description
ga_model_edit(decomp_ga, description = "Changed")

}
}
\seealso{
Other GA modelling functions: 
\code{\link{ga_model_example}()},
\code{\link{ga_model_load}()},
\code{\link{ga_model_make}()},
\code{\link{ga_model_save}()},
\code{\link{ga_model_shiny_load}()},
\code{\link{ga_model_shiny_template}()},
\code{\link{ga_model_shiny}()},
\code{\link{ga_model_write}()},
\code{\link{ga_model}()}
}
\concept{GA modelling functions}
