% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohorts.R
\name{make_cohort_group}
\alias{make_cohort_group}
\title{Create a cohort group}
\usage{
make_cohort_group(cohorts, lifetimeValue = FALSE, cohort_types = NULL)
}
\arguments{
\item{cohorts}{A named list of start/end date pairs}

\item{lifetimeValue}{lifetimeValue TRUE or FALSE.  Only works for webapps.}

\item{cohort_types}{placeholder, does nothing as only FIRST_VISIT_DATE supported.}
}
\value{
A cohortGroup object
}
\description{
Create a cohort group
}
\details{
Example: \code{list("cohort 1" = c("2015-08-01", "2015-08-01"),  "cohort 2" = c("2015-07-01","2015-07-01"))}
}
\examples{

\dontrun{
library(googleAnalyticsR)

## authenticate, 
## or use the RStudio Addin "Google API Auth" with analytics scopes set
ga_auth()

## get your accounts
account_list <- google_analytics_account_list()

## pick a profile with data to query

ga_id <- account_list[23,'viewId']


## first make a cohort group

cohort4 <- make_cohort_group(list("cohort 1" = c("2015-08-01", "2015-08-01"), 
                                  "cohort 2" = c("2015-07-01","2015-07-01")))
                                  
## then call cohort report.  No date_range and must include metrics and dimensions
##   from the cohort list
cohort_example <- google_analytics(ga_id, 
                                   dimensions=c('cohort'), 
                                   cohort = cohort4, 
                                   metrics = c('cohortTotalUsers'))
                                     
                                     
### Lifetime Value report - just a variation of the cohort report 
# with lifetimeValue = TRUE
### and ltv specific metrics
### The view MUST be an app view at the moment
 
## make a cohort group with lifetimeValue = TRUE
 
cohort_ltv <- make_cohort_group(list("cohort 1" = c("2018-12-01", "2018-12-31"), 
                                     "cohort 2" = c("2019-01-01", "2019-01-31")),
                                     lifetimeValue = TRUE)
                                     
## call a cohort report with ltv metrics

ltv_example <- google_analytics(ga_id, 
     dimensions = c('cohort', "acquisitionTrafficChannel"), 
     cohorts = cohort_ltv, 
     metrics = c("cohortGoalCompletionsPerUserWithLifetimeCriteria"))              
                                    
}

}
\seealso{
\url{https://developers.google.com/analytics/devguides/reporting/core/v4/advanced#cohort_and_lifetime_value_ltv_dimensions_and_metrics}
}
\concept{v4 cohort functions}
