#' Create a GA4 Pivot object for the Data API
#' 
#' 
## #' @export
# ga_data_pivot <- function(fields,
#                           orderBys = NULL,
#                           offset = 0,
#                           limit = 10,
#                           metricAggregations = NULL){
#   
#   
# }

#' PivotOrderBy Object
#'
#' @details
#' Autogenerated via [googleAuthR::gar_create_api_objects()]
#' Sorts by a pivot column group.
#'
#' @param pivotSelections Used to select a dimension name and value pivot
#' @param metricName In the response to order by, order rows by this column
#'
#' @return PivotOrderBy object
#'
#' @family PivotOrderBy functions
#' @noRd
PivotOrderBy <- function(pivotSelections = NULL, metricName = NULL) {
  structure(
    list(pivotSelections = pivotSelections, 
         metricName = metricName), 
    class = c("gar_PivotOrderBy","list"))
}

is.PivotOrderBy <- function(x){
  inherits(x, "gar_PivotOrderBy")
}

#' Pivot Object
#' 
#' @param fieldNames Dimension names for visible columns in the report response
#' @param orderBys Specifies how dimensions are ordered in the pivot
#' @param offset The row count of the start row. The first row is counted as row 0
#' @param limit The number of rows to return in this pivot. If unspecified, 10 rows are returned. If -1, all rows are returned.
#' @param metricAggregations Aggregate the metrics by dimensions in this pivot using the specified metricAggregations.
#' 
#' @return Pivot Object
#' @noRd
PivotObject <- function(fieldNames,
                        orderBys = NULL,
                        offset = NULL,
                        limit = NULL,
                        metricAggregations = NULL){
  
  assert_that(is.character(fieldNames))
  assert_that_ifnn(is.OrderBy(orderBys[[1]]))
  assert_that_ifnn(is.numeric(offset))
  assert_that_ifnn(is.numeric(limit))
  assert_that_ifnn(is.character(metricAggregations))
  assert_that_ifnn(all(metricAggregations %in% c("TOTAL",
                                                 "MINIMUM",
                                                 "MAXIMUM",
                                                 "COUNT")))
  
  structure(
    list(
      fieldNames = fieldNames,
      orderBys = orderBys,
      offset = offset,
      limit = limit,
      metricAggregations = metricAggregations
    ),
    class = c("gar_Pivot", "list")
  )
}

is.Pivot <- function(x){
  inherits(x, "gar_Pivot")
}
