% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webprops.R
\name{ga_webproperty_list}
\alias{ga_webproperty_list}
\title{List web properties}
\usage{
ga_webproperty_list(accountId)
}
\arguments{
\item{accountId}{Account Id}
}
\value{
A \code{data.frame} of webproperty meta-data
}
\description{
This gets the meta data for web properties associated with a particular accountId. 
If you want all information available to your user, use \link{ga_account_list} instead.
}
\examples{

\dontrun{
library(googleAnalyticsR)
ga_auth()
aa <- ga_accounts()
wp <- ga_webproperty_list(aa$id[1])
}
}
\seealso{
Other account structure functions: \code{\link{ga_accounts}},
  \code{\link{ga_view_list}}, \code{\link{ga_view}},
  \code{\link{ga_webproperty}},
  \code{\link{google_analytics_account_list}}
}
