% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulkroben.R
\name{pulkroben}
\alias{pulkroben}
\title{Pulkstenis-Robinson Test for Categorical Response Models}
\usage{
pulkroben(model, test = c("chisq", "deviance"), tables = FALSE)
}
\arguments{
\item{model}{a model object or data.frame of observed and estimated
values. The following class of objects can be directly passed to the
\code{pulkroben} function: vglm(), serp(), polr(), and clm(). Other class of
objects require providing a data.frame of observed and predicted values.}

\item{test}{chooses between the chi-squared and the deviance test statistic.}

\item{tables}{Default to FALSE. When TRUE, both the observed and the
expected frequency tables are printed alongside test results.}
}
\value{
\item{stat}{realized value of the chi-square or deviance statistic.}

\item{df}{the degrees of freedom.}

\item{p.value}{the p-value of the test statistic.}

\item{observed}{a table of the observed frequencies.}

\item{expected}{a table of the estimated frequencies.}

\item{rho}{percentage of estimated frequencies greater than one.}

\item{test}{a character vector of the type of test statistic used.}

\item{tables}{a TRUE or FALSE logical vector.}
}
\description{
This provides a post estimation goodness-of-fit test for
the ordinal response models. Supported models include the proportional odds,
adjacent-category, and constrained continuation-ratio models.
}
\details{
The Pulkstenis-Robinson test groups the observations using the covariate
patterns obtained from the categorical covariates. Each covariate pattern
is subsequently split in two based on the median ordinal scores. The test
statistic (chi-sq or deviance) is obtaned using the tabulated observed and
estimated frequencies. Assuming c is the number of covariate patterns, r the
number of response categories and k the number of categorical variables in
the model, the test statistic approximates the chi-sq distribution with
(2c - 1)(r - 1) - k - 1 degrees of freedom (Pulkstenis and Robinson (2004)).
As recommended in Fagerland and Hosmer (2016, 2017), this test should
be compared with the Hosmer-Lemeshow and the Lipsitz tests.
}
\examples{

require(VGAM)

set.seed(1)
n <- 200
y <- ordered(rbinom(n, 2, 0.5))
x1 <- factor(rbinom(n, 1, 0.7))
x2 <- runif(n)

## proportional odds model
vg <- vglm(y ~ x1 + x2, model = TRUE,
           family = cumulative(link = "logitlink", parallel = TRUE))
pulkroben(vg, tables = TRUE)

## adjacent category model
ac <- update(vg, family = acat(parallel = TRUE))
pulkroben(ac, tables = TRUE)

## continuation ratio model
cr <- update(vg, family = cratio(parallel = TRUE))
pulkroben(cr, tables = TRUE)

}
\references{
Pulkstenis, E. and Robinson, T. J. (2004). Goodness-of-fit tests for ordinal
    response regression models. \emph{Statistics in Medicine} 23, 999-1014.

Fagerland, M. W. and Hosmer, D. W. (2016). Tests for goodness of fit in
    ordinal logistic regression models. \emph{Journal of Statistical
    Computation and Simulation}, 86, 3398-3418.

Fagerland, M. W. and Hosmer, D. W. (2017). How to test for goodness of fit
    in ordinal logistic regression models. \emph{Stata Journal}, 17, 668-686.
}
\seealso{
\code{\link{hosmerlem}}, \code{\link{lipsitz}}, \code{\link{brant.test}},
\code{\link{LR.test}}
}
