% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.joint.R
\name{summary.joint}
\alias{summary.joint}
\title{Summary of an \code{joint} object.}
\usage{
\method{summary}{joint}(object, ...)
}
\arguments{
\item{object}{a joint model fit by the \code{joint} function.}

\item{...}{additional arguments (none used).}
}
\value{
Object of class \code{summary.joint}.
}
\description{
Generate summary of a fitted multivariate joint model.
}
\examples{
\donttest{
data(PBC)
long.formula <- list(
  platelets ~ time * drug + (1 + time|id),
  albumin ~ time * drug + (1 + time|id)
)
surv.formula <- Surv(survtime, status) ~ sex + drug

PBC <- na.omit(PBC[,c('id', 'survtime', 'status', 'sex', 
                      'drug', 'platelets', 'albumin', 'time')])
fit <- joint(long.formula, surv.formula, PBC, family = list('genpois', 'gaussian'),
            control = list(verbose = TRUE))
summary(fit)
}
}
\seealso{
\code{\link{joint}} and \code{\link{joint.object}}
}
\author{
James Murray \email{j.murray7@ncl.ac.uk}
}
