% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-convert.R
\name{md_disallow}
\alias{md_disallow}
\title{Disallow certain raw HTML}
\usage{
md_disallow(html)
}
\arguments{
\item{html}{A character vector of \emph{markdown} text to be converted.}
}
\value{
A \code{glue} vector of length 1 containing HTML tags.
}
\description{
Take a character vector of raw HTML text (possibly via \code{\link[=md_convert]{md_convert()}}) and
disallow certain tags by replacing \code{<} with \verb{&lt;}.
}
\details{
GFM enables the tagfilter extension, where the following HTML tags will be
filtered when rendering HTML output:
\itemize{
\item \verb{<title>}
\item \verb{<textarea>}
\item \verb{<style>}
\item \verb{<xmp>}
\item \verb{<iframe>}
\item \verb{<noembed>}
\item \verb{<noframes>}
\item \verb{<script>}
\item \verb{<plaintext>}
}

Filtering is done by replacing the leading \code{<} with the entity \verb{&lt;}. These
tags are chosen in particular as they change how HTML is interpreted in a way
unique to them (i.e. nested HTML is interpreted differently), and this is
usually undesireable (sic) in the context of other rendered Markdown content.

All other HTML tags are left untouched.
}
\examples{
md_disallow("<title>GitHub Flavored Markdown Spec</title>")
}
\seealso{
Other inline functions: 
\code{\link{md_autolink}()},
\code{\link{md_bold}()},
\code{\link{md_code}()},
\code{\link{md_convert}()},
\code{\link{md_escape}()},
\code{\link{md_hardline}()},
\code{\link{md_image}()},
\code{\link{md_issue}()},
\code{\link{md_italic}()},
\code{\link{md_link}()},
\code{\link{md_softline}()},
\code{\link{md_strike}()},
\code{\link{md_text}()}
}
\concept{inline functions}
