% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-chunk.R
\name{md_chunk}
\alias{md_chunk}
\title{Markdown code block}
\usage{
md_chunk(x, type = c("tick", "tilde", "indent"), ...)
}
\arguments{
\item{x}{A character vector of lines to be wrapped concatenated into a single
block, possibly created by \code{\link[=readLines]{readLines()}} or \code{\link[=deparse]{deparse()}}.}

\item{type}{The type of code block to be created. Either "tick", "tilde"
(which call \code{\link[=md_fence]{md_fence()}}) or "indent" (which calls \code{\link[=md_indent]{md_indent()}}).}

\item{...}{Arguments to be passed to \code{\link[=md_fence]{md_fence()}} or \code{\link[=md_indent]{md_indent()}}.}
}
\value{
A \code{glue} object of length 1, with elements of \code{x} formatted via
\code{\link[=md_fence]{md_fence()}} or \code{\link[=md_indent]{md_indent()}}.
}
\description{
Take a character vector of lines and return a glue vector
}
\details{
Turn a character vector of lines into a single code block either indented or
fenced in tildes or backticks. This markdown leaf block can be rendered as
nested HTML \verb{<code>} and \verb{<pre>} tags. This function either calls
\code{\link[=md_fence]{md_fence()}} or \code{\link[=md_indent]{md_indent()}} based on the \code{type} argument.
}
\examples{
md_chunk("$ sudo apt install r-base-dev", info = "bash")
md_chunk(c("library(ggplot2)", "ggplot(mpg)+", "geom_point(aes(displ, hwy))"), type = "tilde")
md_indent(
  n = c(4, 4, 6),
  x = c(
    "library(dplyr)",
    "starwars \%>\%",
    "filter(species == 'Droid')"
  )
)
}
\seealso{
Other leaf block functions: 
\code{\link{md_blank}()},
\code{\link{md_fence}()},
\code{\link{md_heading}()},
\code{\link{md_indent}()},
\code{\link{md_paragraph}()},
\code{\link{md_reference}()},
\code{\link{md_rule}()},
\code{\link{md_setext}()},
\code{\link{md_table}()}
}
\concept{leaf block functions}
