% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-reference.R
\name{md_reference}
\alias{md_reference}
\title{Markdown link reference}
\usage{
md_reference(label, url, title = NULL)
}
\arguments{
\item{label}{A link label that is referenced elsewhere in the document.}

\item{url}{The URL to hyperlink the referenced text with.}

\item{title}{An \emph{optional} link title; defaults to \code{NULL}.}
}
\value{
A single \code{glue} vector of length equal to that of \code{label} and \code{url},
with elements the concatenated arguments.
}
\description{
Take character vectors of link texts, link destinations, and optional titles
and return single glue vector of valid markdown link references. This
markdown leaf block then uses the \code{label} placed \emph{elsewhere} in a markdown
document to render \code{<href>} HTML tags.
}
\details{
A full reference link (6.6) consists of a link text immediately followed by a
link label that matches a link reference definition elsewhere in the
document...

A link reference definition consists of a link label, indented up to three
spaces, followed by a colon (\code{:}), optional whitespace (including up to one
line ending), a link destination, optional whitespace (including up to one
line ending), and an optional link title, which if it is present must be
separated from the link destination by whitespace. No further non-whitespace
characters may occur on the line.

A link reference definition does not correspond to a structural element of a
document. Instead, it defines a label which can be used in reference links
and reference-style images elsewhere in the document. Link reference
definitions can come either before or after the links that use them.
}
\examples{
md_reference("tv", "https://www.tidyverse.org/", "tidyverse")
md_reference(label = 1:2, url = c("https://one.org", "https://two.com"))
}
\seealso{
Other leaf block functions: \code{\link{md_blank}},
  \code{\link{md_chunk}}, \code{\link{md_fence}},
  \code{\link{md_heading}}, \code{\link{md_indent}},
  \code{\link{md_paragraph}}, \code{\link{md_rule}},
  \code{\link{md_setext}}, \code{\link{md_table}}
}
\concept{leaf block functions}
