% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-issue.R
\name{md_issue}
\alias{md_issue}
\title{Markdown GitHub issue}
\usage{
md_issue(repo, num)
}
\arguments{
\item{repo}{A character vector in the format \code{"user/rep"}.}

\item{num}{The issue or pull number \emph{without} hash symbol.}
}
\value{
A character vector which GitHub can automatically hyperlink.
}
\description{
Take a character vector and numeric vector and concatenate them into a glue
vector of valid GitHub issue autolinks (username/repo#issue).
}
\details{
Within conversations on GitHub, references to issues and pull requests are
\href{https://help.github.com/en/github/writing-on-github/autolinked-references-and-urls#issues-and-pull-requests}{automatically converted to shortened links}.
}
\examples{
md_issue("kiernann/gluedown", 1:5)
}
\seealso{
Other inline functions: \code{\link{md_autolink}},
  \code{\link{md_bold}}, \code{\link{md_code}},
  \code{\link{md_convert}}, \code{\link{md_disallow}},
  \code{\link{md_escape}}, \code{\link{md_hardline}},
  \code{\link{md_image}}, \code{\link{md_italic}},
  \code{\link{md_link}}, \code{\link{md_softline}},
  \code{\link{md_strike}}, \code{\link{md_text}}

Other markdown extensions: \code{\link{md_strike}},
  \code{\link{md_table}}
}
\concept{inline functions}
\concept{markdown extensions}
