% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.glmnetr_230218.R
\name{glmnetr.simdata}
\alias{glmnetr.simdata}
\title{Generate example data}
\usage{
glmnetr.simdata(nrows = 1000, ncols = 100, beta = NULL)
}
\arguments{
\item{nrows}{Sample size (>=100) for simulated data, default=1000.}

\item{ncols}{Number of columns (>=17) in design matrix, i.e. predictors, default=100.}

\item{beta}{Vector of length <= ncols for "left most" coefficients.  If beta has 
length < ncols, then the values at length(beta)+1 to ncols are set to 0.
Default=NULL, where a beta of length 25 is assigned standard normal values.}
}
\value{
A list with elements xs for desing matrix, y_ for a quantitative outcome, 
yt for a survival time, event for an indicator of event (1) or censoring (0), 
in the Cox proportional hazards survival model setting, yb for 
yes/no (binomial) outcome data, and beta the beta used in random number generation.
}
\description{
Generate an example data set with specified number of observations, 
and predictors.  The first column in the design matrix is identically equal to 1
for an intercept.  Columns 2 to 5 are for the 4 levels of a character variable, 
6 to 11 for the 6 levels of another character variable.  Columns 12 to 17 are for 3
binomial predictors, again over parameterized.  Such over parameterization
can cause difficulties with the glmnet() of the 'glmnet' package.
}
\examples{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
# for Cox PH survial model data 
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
# for linear regression model data 
xs=sim.data$xs 
y_=sim.data$y_
# for logistic regression model data 
xs=sim.data$xs 
y_=sim.data$yb

}
\seealso{
\code{\link{glmnetr}} , \code{\link{cv.glmnetr}} , \code{\link{nested.glmnetr}}
}
