% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.cv.glmnet.R
\name{print.cv.glmnet}
\alias{print.cv.glmnet}
\alias{print.cv.relaxed}
\title{print a cross-validated glmnet object}
\usage{
\method{print}{cv.glmnet}(x, digits = max(3, getOption("digits") - 3),
  ...)
}
\arguments{
\item{x}{fitted 'cv.glmnet' object}

\item{digits}{significant digits in printout}

\item{\dots}{additional print arguments}
}
\description{
Print a summary of the results of cross-validation for a glmnet model.
}
\details{
A summary of the cross-validated fit is produced, slightly different for a
'cv.relaxed' object than for a 'cv.glmnet' object.  Note that a 'cv.relaxed'
object inherits from class 'cv.glmnet', so by directly invoking
\code{print.cv.glmnet(object)} will print the summary as if
\code{relax=TRUE} had not been used.
}
\examples{

x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit1 = cv.glmnet(x, y)
print(fit1)
fit1r = cv.glmnet(x, y, relax = TRUE)
print(fit1r)
## print.cv.glmnet(fit1r)  ## CHECK WITH TREVOR
}
\references{
Friedman, J., Hastie, T. and Tibshirani, R. (2008)
\emph{Regularization Paths for Generalized Linear Models via Coordinate
Descent}\cr \url{https://arxiv.org/abs/1707.08692}\cr Hastie, T.,
Tibshirani, Robert, Tibshirani, Ryan (2019) \emph{Extended Comparisons of
Best Subset Selection, Forward Stepwise Selection, and the Lasso}
}
\seealso{
\code{glmnet}, \code{predict} and \code{coef} methods.
}
\author{
Jerome Friedman, Trevor Hastie and Rob Tibshirani\cr Maintainer:
Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
