% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{simulate_new}
\alias{simulate_new}
\title{Simulate from covariate/metadata in the absence of a real data set (EXPERIMENTAL)}
\usage{
simulate_new(
  object,
  nsim = 1,
  seed = NULL,
  family = gaussian,
  newdata,
  newparams,
  ...,
  show_pars = FALSE
)
}
\arguments{
\item{object}{a \emph{one-sided} model formula (e.g. \code{~ a + b + c}
(peculiar naming is for consistency with the generic function, which typically
takes a fitted model object)}

\item{nsim}{number of simulations}

\item{seed}{random-number seed}

\item{family}{a family function, a character string naming a family function, or the result of a call to a family function (variance/link function) information. See \code{\link{family}} for a generic discussion of families or \code{\link{family_glmmTMB}} for details of \code{glmmTMB}-specific families.}

\item{newdata}{a data frame containing all variables listed in the formula,
\emph{including} the response variable (which needs to fall within
the domain of the conditional distribution, and should probably not
be all zeros, but whose value is otherwise irrelevant)}

\item{newparams}{a list of parameters containing sub-vectors
(\code{beta}, \code{betazi}, \code{betad}, \code{theta}, etc.) to
be used in the model}

\item{...}{other arguments to \code{glmmTMB} (e.g. \code{family})}

\item{show_pars}{(logical) print structure of parameter vector and stop without simulating?}
}
\description{
See \code{vignette("sim", package = "glmmTMB")} for more details and examples,
and \code{vignette("covstruct", package = "glmmTMB")}
for more information on the parameterization of different covariance structures.
}
\examples{
## use Salamanders data for structure/covariates
simulate_new(~ mined + (1|site),
             zi = ~ mined,
             newdata = Salamanders, show_pars  = TRUE)
sim_count <- simulate_new(~ mined + (1|site),
             newdata = Salamanders,
             zi = ~ mined,
             family = nbinom2,
             newparams = list(beta = c(2, 1),
                         betazi = c(-0.5, 0.5), ## logit-linear model for zi
                         betad = log(2), ## log(NB dispersion)
                         theta = log(1)) ## log(among-site SD)
)
head(sim_count[[1]])
}
