% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_cor}
\alias{get_cor}
\title{translate vector of correlation parameters to correlation values}
\usage{
get_cor(theta)
}
\arguments{
\item{theta}{vector of internal correlation parameters (elements of scaled Cholesky factor, in \emph{row-major} order)}
}
\value{
a vector of correlation values
}
\description{
translate vector of correlation parameters to correlation values
}
\details{
This function follows the definition at \url{http://kaskr.github.io/adcomp/classUNSTRUCTURED__CORR__t.html}:
if \eqn{L} is the lower-triangular matrix with 1 on the diagonal and the correlation parameters in the lower triangle, then the correlation matrix is defined as \eqn{\Sigma = D^{-1/2} L L^\top D^{-1/2}}{Sigma = sqrt(D) L L' sqrt(D)}, where \eqn{D = \textrm{diag}(L L^\top)}{D = diag(L L')}. For a single correlation parameter \eqn{\theta_0}{theta0}, this works out to \eqn{\rho = \theta_0/\sqrt{1+\theta_0^2}}{rho = theta0/sqrt(1+theta0^2)}. The function returns the elements of the lower triangle of the correlation matrix, in column-major order.
}
\examples{
th0 <- 0.5
stopifnot(all.equal(get_cor(th0),th0/sqrt(1+th0^2)))
get_cor(c(0.5,0.2,0.5))
}
