% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB.R
\name{glmmTMBControl}
\alias{glmmTMBControl}
\title{Control parameters for glmmTMB optimization}
\usage{
glmmTMBControl(optCtrl = list(iter.max = 300, eval.max = 400),
  profile = FALSE)
}
\arguments{
\item{optCtrl}{Passed as argument \code{control} to \code{nlminb}.}

\item{profile}{Logical; Experimental option to improve speed and
robustness when a model has many fixed effects}
}
\description{
Control parameters for glmmTMB optimization
}
\details{
The general non-linear optimizer \code{nlminb} is used by
\code{\link{glmmTMB}} for parameter estimation. It may sometimes be
necessary to tweak some tolerances in order to make a model
converge. For instance, the warning \sQuote{iteration limit reached
without convergence} may be fixed by increasing the number of
iterations using something like

\code{glmmTMBControl(optCtrl=list(iter.max=1e3,eval.max=1e3))}.

The argument \code{profile} allows \code{glmmTMB} to use some special
properties of the optimization problem in order to speed up estimation
in cases with many fixed effects. Enable this option using

\code{glmmTMBControl(profile=TRUE)}.

Control parameters may depend on the model specification, because each
control component is evaluated inside \code{TMBStruc}, the output
of \code{mkTMBStruc}.  To specify that \code{profile} should be
enabled for more than 5 fixed effects one can use

\code{glmmTMBControl(profile=quote(length(parameters$beta)>=5))}.
}
