% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairedPlots.R
\name{pairedPlot}
\alias{pairedPlot}
\title{Paired plots}
\usage{
pairedPlot(
  glmmResult,
  geneName = NULL,
  x1Label = NULL,
  x2Label = NULL,
  IDColumn = "ID",
  xTitle = NULL,
  yTitle = "Gene Expression",
  title = NULL,
  logTransform = FALSE,
  shapes = 19,
  colours = "red",
  lineColours = "grey60",
  markerSize = 2,
  fontSize = NULL,
  alpha = 0.7,
  x2Offset = 6,
  pairedOnly = TRUE,
  graphics = "base",
  addModel = TRUE,
  modelSize = 3,
  modelColours = "black",
  modelLineSize = 1,
  modelLineColours = NULL,
  addBox = FALSE,
  addViolins = TRUE,
  violinWidth = 0.5,
  ...
)
}
\arguments{
\item{glmmResult}{A glmmSeq object created by
\code{\link[glmmSeq:glmmSeq]{glmmSeq::glmmSeq()}}}

\item{geneName}{The gene/row name to be plotted}

\item{x1Label}{The name of the first (inner) x parameter. This must be able
to be paired using the ID.}

\item{x2Label}{The name of the second (outer) x parameter}

\item{IDColumn}{Column name of sample IDs for pairing}

\item{xTitle}{Title for the x axis}

\item{yTitle}{Title for the y axis}

\item{title}{Plot title. If NULL gene name is used}

\item{logTransform}{Whether to perform a log10 transform on the y axis}

\item{shapes}{The marker shapes (default=19)}

\item{colours}{The marker colours (default='red') as vector or named vector}

\item{lineColours}{The line colours (default='grey60') as vector or named
vector}

\item{markerSize}{Size of markers (default=2)}

\item{fontSize}{Plot font size}

\item{alpha}{Line and marker opacity (default=0.7)}

\item{x2Offset}{Vertical adjustment to secondary x-axis (default=6)}

\item{pairedOnly}{Logical whether to only plot paired samples (default=TRUE)}

\item{graphics}{Which graphic system to use (options = "base" or "ggplot")}

\item{addModel}{Whether to add the fit model with markers (default=TRUE)}

\item{modelSize}{Size of model points (default=3)}

\item{modelColours}{Colour of model fit markers (default="black") as vector
or named vector}

\item{modelLineSize}{Size of model points (default=1) as vector or named
vector}

\item{modelLineColours}{Colour of model fit lines. If NULL same colours as
modelColour used (default=NULL).}

\item{addBox}{Logical whether to add boxplots for mean and IQR.}

\item{addViolins}{Logical whether to add half violin-plots (ggplot only),
default=TRUE}

\item{violinWidth}{Width of violin plots (default=0.5)}

\item{...}{Other parameters to pass to
\code{\link[graphics:plot]{graphics::plot()}} or
\code{\link[ggplot2:theme]{ggplot2::theme()}}.}
}
\value{
Returns a paired plot for matched samples.
}
\description{
Paired plots to show differences between groups and over time
}
\examples{
data(PEAC_minimal_load)

disp <- apply(tpm, 1, function(x){
(var(x, na.rm=TRUE)-mean(x, na.rm=TRUE))/(mean(x, na.rm=TRUE)**2)
})

MS4A1glmm <- glmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                     id = 'PATID',
                     countdata = tpm['MS4A1', ],
                     metadata = metadata,
                     dispersion = disp['MS4A1'],
                     removeDuplicatedMeasures=TRUE,
                     verbose=FALSE)

pairedPlot(glmmResult=MS4A1glmm,
           geneName = 'MS4A1',
           x1Label = 'Timepoint',
           x2Label='EULAR_6m',
           IDColumn = 'PATID',
           colours = c('skyblue', 'goldenrod1', 'mediumvioletred'),
           graphics = 'base')
}
