% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordiplot.gllvm.R
\name{ordiplot.gllvm}
\alias{ordiplot.gllvm}
\alias{ordiplot}
\title{Plot latent variables from gllvm model}
\usage{
\method{ordiplot}{gllvm}(object, biplot = FALSE, ind.spp = NULL,
  alpha = 0.5, main = NULL, which.lvs = c(1, 2),
  predict.region = FALSE, level = 0.95, jitter = FALSE,
  jitter.amount = 0.2, s.colors = 1, symbols = FALSE,
  cex.spp = 0.7, lwd.ellips = 0.5, col.ellips = 4, lty.ellips = 1,
  ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{biplot}{\code{TRUE} if both latent variables and their coefficients are plotted, \code{FALSE} if only latent variables.}

\item{ind.spp}{the number of response variables (usually, species) to include on the biplot. The default is none, or all if \code{biplot = TRUE}.}

\item{alpha}{a numeric scalar between 0 and 1 that is used to control the relative scaling of the latent variables and their coefficients, when constructing a biplot.}

\item{main}{main title.}

\item{which.lvs}{indices of two latent variables to be plotted if number of the latent variables is more than 2. A vector with length of two. Defaults to \code{c(1,2)}.}

\item{predict.region}{logical, if \code{TRUE} prediction regions for the predicted latent variables are plotted, defaults to \code{FALSE}.}

\item{level}{level for prediction regions.}

\item{jitter}{if \code{TRUE}, jittering is applied on points.}

\item{jitter.amount}{numeric, positive value indicating an amount of jittering for each point, defaults to 0.2 (jitter range).}

\item{s.colors}{colors for sites}

\item{symbols}{logical, if \code{TRUE} sites are plotted using symbols, if \code{FALSE} (default) site numbers are used}

\item{cex.spp}{size of species labels in biplot}

\item{lwd.ellips}{line width for prediction ellipses. See graphical parameter lwd.}

\item{col.ellips}{colors for prediction ellipses.}

\item{lty.ellips}{line type for prediction ellipses. See graphical parameter lty.}

\item{...}{additional graphical arguments.}
}
\description{
Plots latent variables and their corresponding coefficients (biplot).
}
\details{
Function constructs a scatter plot of two latent variables, i.e. an ordination plot. If only one latent
variable is in the fitted model, latent variables are plotted against their corresponding row indices.
The latent variables are labeled using the row index of the response matrix y.

Coefficients related to latent variables are plotted in the same figure with the latent
variables if \code{biplot = TRUE}. They are labeled using the column names of y. The number
of latent variable coefficients to be plotted can be controlled by ind.spp. An argument alpha
is used to control the relative scaling of the latent variables and their coefficients.
If \code{alpha = 0.5}, the latent variables and their coefficients are on the same scale.
For details for constructing a biplot, see Gabriel (1971).
}
\note{
- If error is occurred when using \code{ordiplot()}, try full name of the function \code{ordiplot.gllvm()} as functions named 'ordiplot' might be found in other packages as well.
}
\examples{
#'## Load a dataset from the mvabund package
data(antTraits)
y <- as.matrix(antTraits$abund)
fit <- gllvm(y, family = poisson())
# Ordination plot:
ordiplot(fit)
# Biplot with 10 species
ordiplot(fit, biplot = TRUE, ind.spp = 10)

}
\references{
Gabriel, K. R. (1971). The biplot graphic display of matrices with application to principal component analysis. Biometrika, 58, 453-467.
}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>, Francis K.C. Hui
}
