% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptiveTableMunich2019dataset.R
\name{descriptiveTableMunich2019dataset}
\alias{descriptiveTableMunich2019dataset}
\title{Descriptive statistics table for the munich2019dataset}
\usage{
descriptiveTableMunich2019dataset(savePath = NULL)
}
\arguments{
\item{savePath}{Character (optional). String specifying the path and filename
for exporting the table.
\itemize{
\item If NULL (default), the table will not be exported.
\item If "" (empty string), the table will be saved in the working directory
using a default name.
\item Expected format: 'filepath/filename.extensions' where:
\itemize{
\item filepath is the directory (must already exist), default is the working directory;
\item filename is the name of the file, default to 'table_munich2019dataset_timestamp.png';
\item extension must be one of png, pdf html and must be specified, unless using the default filename.
}
}}
}
\value{
A 'table1' object containing descriptive statistics grouped by survival status.
}
\description{
Function to create, display and optionally export a table
containing descriptive statistics for the munich2019dataset.\cr
The table is created using the table1 package and is grouped by survival status.
}
\examples{
# Create and display the table, without saving anything
descriptiveTableMunich2019dataset()

\donttest{
# Create, display and save the table giving a path, filename and extension
descriptiveTableMunich2019dataset(savePath = "tables/munich_web_table.html")

# Create, display and save the table giving a path, filename and extension
descriptiveTableMunich2019dataset(savePath = "tables/munich_table.pdf")

# Create, display and save the table giving only the path, default name will be used
descriptiveTableMunich2019dataset(savePath = "tables/")

# Create, display and save the table giving a path and filename, default extension will be used
descriptiveTableMunich2019dataset(savePath = "tables/munich_table")
}


}
\seealso{
\code{\link[table1:table1]{table1::table1()}}
}
