% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ou.R
\name{oupar}
\alias{oupar}
\alias{oujac}
\alias{ouhess}
\title{Parameterisation functions of Ornstein-Uhlenbeck model}
\usage{
oupar(par, t, ...)

oujac(par, t, ...)

ouhess(par, t, ...)
}
\arguments{
\item{par}{A numeric vector containing the joint vector of the
Ornstein-Uhlenbeck drift matrix, long-term mean,
and volitality matrix, which is a lower-triangular
Cholesky factor.}

\item{t}{Branch length of the currently processing node.}

\item{...}{Unused in these functions. Their existence is needed because
\code{\link{lik.glinv}} etc. always pass us four arguments.
See \code{\link{lik.glinv}} for details.}
}
\value{
\code{oupar} returns the a vector of concatenated \eqn{(\Phi, w, V')},
               where \eqn{V'} is the lower triangular part of \eqn{V}. \code{oujac}
               returns the Jacobian matrix of \code{oupar}. \code{ouhess} returns
               a list of three 3D arrays, named \code{Phi}, \code{w}, \code{V} respectively inside the list, in which
               \code{ouhess(...)$Phi[m,i,j]} contains
               the cross second-order partial derivative of \eqn{\Phi_m} (here we treat the matrix \eqn{\Phi} as a
               column-major-flattened vector) with respect to the \eqn{i}-th and\eqn{j}-th user parameters;
               and \code{ouhess(...)$w[m,i,j]} and \code{((parhess[[i]])(...))$V[m,i,j]}
               analogously contains second-order derivative of \eqn{w_m} and \eqn{V'_m}.
}
\description{
\code{oupar} is a function that maps from the Ornstein-Uhlenbeck model
parameters to the Gaussian parametersation.

\code{oujac} accepts the same arguments as \code{oupar} and returns the
Jacobian matrix of \code{oupar}.

\code{ouhess} accepts the same arguments as \code{oupar}
and returns all the second derivatives \code{oupar}. The returned
values are consistent with the format required by \code{\link{glinv}}.
}
\details{
By multivariate Ornstein-Uhlenbeck process, we mean
    \deqn{dx(t) = -H(x(t) - \theta)dt + \Sigma_x dW(t)}
where \eqn{H} is a \eqn{k}-by-\eqn{k} matrix with real entries,
\eqn{\theta} is any real \eqn{k}-vector, \eqn{\Sigma_x} is a
lower-triangular matrix, \eqn{W(t)} is the Brownian motion process.
The parameters of this model is \eqn{(H,\theta,\Sigma_x)},
therefore \eqn{k^2+k+k(k+1)/2} dimensional.

This package uses parameterisation \eqn{(H,\theta,\Sigma_x')}, where
\eqn{H} and \eqn{\theta} is the same as above defined, and \eqn{\Sigma_x'}
is the lower-triangular part of \eqn{\Sigma_x}, except that, only on diagonal
entries, \eqn{\Sigma_x'=log(\Sigma_x)}. The use of logarithm is for
eliminating multiple local maxima in the log-likelihood.

The \code{par} arguemnt is the concatenation of column-major-flattened
\eqn{H}, \eqn{\theta}, and the column-major-flattened lower-triangular part
of \eqn{\Sigma_x'}.
}
