% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTheta.R
\name{getTheta}
\alias{getTheta}
\title{getTheta
Updates theta. Vectorized but only updates observations that have not converged.}
\usage{
getTheta(spt, f0, mu, thetaStart = NULL, thetaControl = theta.control())
}
\arguments{
\item{spt}{Support of the observed response variable. (This is the set of
unique values observed, not the set of all possible values.)}

\item{f0}{Values of the baseline distribution corresponding to the values of spt}

\item{mu}{The fitted mean for each observation. Note these values must lie
strictly within the range of the support.}

\item{thetaStart}{Vector of starting values. One value per observation. If
\code{NULL}, zero is used as the starting value for each observation.}

\item{thetaControl}{Object of class \code{thetaControl}, which is a list of
control arguments returned by the \code{thetaControl} function.}
}
\value{
List containing theta, b (sum(exp(theta*spt))), bPrime (the fitted
means, which should match mu), bPrime2 (the fitted variances), and tiltFact
(sptN x n matrix).
}
\description{
getTheta
Updates theta. Vectorized but only updates observations that have not converged.
}
\keyword{internal}
