% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glance_data.R
\name{glance_data}
\alias{glance_data}
\title{Glance Data}
\usage{
glance_data(x, limit2tally = 20)
}
\arguments{
\item{x}{A dataframe with named columns.}

\item{limit2tally}{One of the summaries is a tally of the distinct
values on each column. If there are too many different values
in a column, this summary would be meaningless. This
\code{limit2tally} is the limit of distinct values to
tally. If there are more than that it returns
"Too many unique values".}
}
\value{
A \code{tibble}.
}
\description{
Provides a summary of data with the the following columns:
\describe{
\item{\code{name}}{Name of the column.}
\item{\code{type}}{Type of the column, equal to "numerical",
"logical", "factor", "categorical", or "NA only".}
\item{\code{distinct_values}}{Count of distinct values. It ignores
NA values. Thus, if a columns only has NAs, then the value of this
field will be zero.}
\item{\code{minimum}}{Minimum of numerical columns excluding NA
values.}
\item{\code{median}}{Median of numerical columns excluding NA
values.}
\item{\code{maximum}}{Maximum of numerical columns excluding NA
values.}
\item{\code{mean}}{Mean of numerical variables. It ignores NAs.}
\item{\code{sd}}{Standard deviation of numerical variables. It
ignores NAs.}
\item{\code{na_proportion}}{Proportion of NAs.}
\item{\code{count}}{Tally of values if the column has 5 values at
most. This value (5) can be modified with the parameter
\code{limit2tally}.}
\item{\code{sample_values}}{Sample of (different) values in each
column.}
}
}
\examples{
glance_data(iris)
}
\author{
Guillermo Basulto-Elias
}
