% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/givitiCalibrationMain.R
\name{givitiCalibrationBelt}
\alias{givitiCalibrationBelt}
\title{Calibration Belt}
\usage{
givitiCalibrationBelt(o, e, devel, subset = NULL, confLevels = c(0.8, 0.95),
  thres = 0.95, maxDeg = 4, nPoints = 200)
}
\arguments{
\item{o}{A numeric vector representing the binary outcomes.
The elements must assume only the values 0 or 1. The predictions
in \code{e} must represent the probability of the event
coded as 1.}

\item{e}{A numeric vector containing the predictions of the
model under evaluation. The elements must be numeric and between 0 and 1.
The lenght of the vector must be equal to the length of the vector \code{o}.}

\item{devel}{A character string specifying if the model has been fit on
the same dataset under evaluation (\code{internal}) or if the model has
been developed on an external sample (\code{external}). See also the 'Details' section.}

\item{subset}{An optional boolean vector specifying the subset of observations
to be considered.}

\item{confLevels}{A numeric vector containing the confidence levels
of the calibration belt. The default values are set to .80 and .95.}

\item{thres}{A numeric scalar between 0 and 1 representing 1 - the significance level
adopted in the forward selection. By default is set to 0.95.}

\item{maxDeg}{The maximum degree considered in the forward selection.
By default is set to 4.}

\item{nPoints}{A numeric scalar indicating the number of points to be considered
to plot the calibration belt. The default value is 200.}
}
\value{
An object of class \code{givitiCalibrationBelt}.
 After computing the calibration belt with the present function,
 the \code{plot} method can be used to plot
 the calibration belt. The object returned is a list that contains the
 following components:
\describe{
  \item{n}{The size of the sample evaluated in the analysis, after discarding
           missing values from the vectors \code{o} and \code{e}.}
  \item{resultCheck}{Result of the check on the data. If the data are compatible with the
                     construction of the calibration belt, the value is the boolean
                     \code{TRUE}. Otherwise, the element contain a character string
                     describing the problem found.}
  \item{m}{The degree of the polynomial at the end of the forward selection.}
  \item{statistic}{The value of the test's statistic.}
  \item{p.value}{The p-value of the test.}
  \item{seqP}{The vector of the probabilities where the points
              of the calibration belt has been evaluated.}
  \item{minMax}{A list with two elements named \code{min} and \code{max}
                representing the minimum and maximum probabilities in the model under evaluation}
  \item{confLevels}{The vector containing the confidence levels of the
                    calibration belt.}
  \item{intersByConfLevel}{A list whose elements report the intervals where the
                           calibration belt is significantly over/under the bisector
                           for each confidence level in \code{confLevels}.}
}
}
\description{
\code{givitiCalibrationBelt} implements the computations necessary
to plot the calibration belt.
}
\details{
The calibration belt and the associated test can be used both to evaluate
the calibration of the model in external samples or in the development dataset. However,
the two cases have different requirements. When a model is evaluated on independent
samples, the calibration belt and the related test can be applied whatever is the
method used to fit the model. Conversely, they can be used on the development set
only if the model is fitted with logistic regression.
}
\examples{
#Random by-construction well calibrated model
e <- runif(100)
o <- rbinom(100, size = 1, prob = e)
cb <- givitiCalibrationBelt(o, e, "external")
plot(cb)

#Random by-construction poorly calibrated model
e <- runif(100)
o <- rbinom(100, size = 1, prob = logistic(logit(e)+2))
cb <- givitiCalibrationBelt(o, e, "external")
plot(cb)
}
\seealso{
\code{\link{plot.givitiCalibrationBelt}}
 to plot the calibaration belt and
 \code{\link{givitiCalibrationTest}} to perform the
 associated calibration test.
}

