% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/givitiCalibrationBeltUtilities.R
\name{calibrationBeltIntersections}
\alias{calibrationBeltIntersections}
\title{Calibration Belt Significant Deviations}
\usage{
calibrationBeltIntersections(cbBound, seqP, minMax)
}
\arguments{
\item{cbBound}{A \code{data.frame} object with the numeric variables "U"
and "L", representing the upper and lower boundary of the calibration belt.}

\item{seqP}{The vector of the the probabilities where the points
of the calibration belt have been evaluated.}

\item{minMax}{A list with two elements, named \code{min} and \code{max},
representing the minimum and maximum probabilities in the model under evaluation.}
}
\value{
A list with two components, \code{overBisector} and \code{underBisector}.
Each component is a list containing all the intervals where the calibration
belt is significantly over/under the bisector.
}
\description{
\code{calibrationBeltIntersections} returns the
 intervals where the calibration belt significantly deviates
 from the bisector.
}
\examples{
e <- runif(1000)
logite <- logit(e)
eMod <- logistic(logit(e) +  (logit(e))^2)
o <- rbinom(1000, size = 1, prob = eMod)
data <- data.frame(e = e, o = o, logite = logite)

seqP <- seq(from = .01, to =.99, by = .01)
seqG <- logit(seqP)

minMax <- list(min = min(e), max = max(e))

fwLR <- polynomialLogRegrFw(data, .95, 4, 1)
cbBound <- calibrationBeltPoints(data, seqG, fwLR$m, fwLR$fit, .95, .90, "external")
calibrationBeltIntersections(cbBound, seqP, minMax)
}
\seealso{
\code{\link{givitiCalibrationBelt}} and \code{\link{plot.givitiCalibrationBelt}}
 to compute and plot the calibaration belt, and
 \code{\link{givitiCalibrationTest}} to perform the
 associated calibration test.
}

