% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_git_status_targets.R
\name{tar_git_status_targets}
\alias{tar_git_status_targets}
\title{Status of the targets (Git)}
\usage{
tar_git_status_targets(
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store"),
  reporter = targets::tar_config_get("reporter_outdated"),
  envir = parent.frame(),
  callr_function = callr::r,
  callr_arguments = targets::callr_args_default(callr_function, reporter)
)
}
\arguments{
\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[targets:tar_script]{tar_script()}},
\code{\link[targets:tar_config_get]{tar_config_get()}}, and \code{\link[targets:tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[targets:tar_config_get]{tar_config_get()}} and \code{\link[targets:tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets are checked. Choices:
\itemize{
\item \code{"silent"}: print nothing.
\item \code{"forecast"}: print running totals of the checked and outdated
targets found so far.
}}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[targets:tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
A \code{tibble} with the names of outdated targets.
}
\description{
Show which targets are outdated.
}
\details{
This function has prettier output than \code{targets::tar_outdated()},
and it mainly serves \code{\link[=tar_git_status]{tar_git_status()}}.
}
\examples{
targets::tar_dir({ # Containing code does not modify the user's file space.
targets::tar_script(tar_target(data, 1))
targets::tar_make()
list.files("_targets", all.files = TRUE)
tar_git_status_targets()
})
}
\seealso{
Other git: 
\code{\link{tar_git_checkout}()},
\code{\link{tar_git_init}()},
\code{\link{tar_git_log}()},
\code{\link{tar_git_ok}()},
\code{\link{tar_git_snapshot}()},
\code{\link{tar_git_status_code}()},
\code{\link{tar_git_status_data}()},
\code{\link{tar_git_status}()}
}
\concept{git}
