% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{gl_push_file}
\alias{gl_push_file}
\alias{gl_delete_file}
\title{Upload, delete a file to a GitLab repository}
\usage{
gl_push_file(
  project,
  file_path,
  content,
  commit_message,
  branch = get_main(),
  overwrite = TRUE,
  ...
)

gl_delete_file(project, file_path, commit_message, branch = get_main(), ...)
}
\arguments{
\item{project}{Project name or id}

\item{file_path}{path where to store file in gl_repository.
If in subdirectory, the parent directory should exist.}

\item{content}{Character of length 1. File content (text)}

\item{commit_message}{Message to use for commit with new/updated file}

\item{branch}{name of branch where to append newly generated commit with new/updated file}

\item{overwrite}{whether to overwrite files that already exist}

\item{...}{passed on to \code{\link[=gitlab]{gitlab()}}}
}
\value{
returns a tibble with changed branch and path (0 rows if
nothing was changed, since overwrite is FALSE)
}
\description{
If the file already exists, it is updated/overwritten by default
}
\examples{
\dontrun{
# Create fake dataset
tmpfile <- tempfile(fileext = ".csv")
write.csv(mtcars, file = tmpfile)
# Push content to repository with a commit
gl_push_file(
  project = <<your-project-id>>,
  file_path = "test_data.csv",
  content = paste(readLines(tmpfile), collapse = "\n"),
  commit_message = "New test data")
}
}
