% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{gl_builds}
\alias{gl_builds}
\alias{gl_latest_build_artifact}
\title{Access the Gitlab CI builds}
\usage{
gl_builds(project, ...)

gl_latest_build_artifact(project, job, branch_name = "master",
  save_to_file = tempfile(fileext = ".zip"), ...)
}
\arguments{
\item{project}{project name or id, required}

\item{...}{passed on to \code{\link{gitlab}} API call}

\item{job}{Name of the job to get build artifacts from}

\item{branch_name}{name of branch}

\item{save_to_file}{either a path where to store .zip file or NULL if raw should be returned}
}
\value{
returns the file path if \code{save_to_file} is TRUE, or the archive as raw otherwise.
}
\description{
List the build with \code{gl_builds} or download the most recent artifacts
archive with \code{gl_latest_build_artifact}. For every branch and job combination
only the most recent artifacts archive is available
}
