% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/blob.r
\name{is_blob}
\alias{is_blob}
\title{Check if object is S4 class git_blob}
\usage{
is_blob(object)
}
\arguments{
\item{object}{Check if object is S4 class git_blob}
}
\value{
TRUE if object is S4 class git_blob, else FALSE
}
\description{
Check if object is S4 class git_blob
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "First commit message")
blob_1 <- tree(commit_1)["example.txt"]

## Check if blob
is_blob(commit_1)
is_blob(blob_1)
}
}
\keyword{methods}

