% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blob.r
\docType{methods}
\name{summary,git_blob-method}
\alias{summary,git_blob-method}
\title{Summary of blob}
\usage{
\S4method{summary}{git_blob}(object, ...)
}
\arguments{
\item{object}{The blob \code{object}}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
None (invisible 'NULL').
}
\description{
Summary of blob
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "First commit message")
blob_1 <- tree(commit_1)["example.txt"]

## Get summary of the blob
summary(blob_1)
}
}
\keyword{methods}

