% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/commit.r
\docType{methods}
\name{commit}
\alias{commit}
\alias{commit,git_repository-method}
\title{Commit}
\usage{
commit(repo, message = NULL, all = FALSE, session = FALSE,
  reference = "HEAD", author = default_signature(repo),
  committer = default_signature(repo))

\S4method{commit}{git_repository}(repo, message = NULL, all = FALSE,
  session = FALSE, reference = "HEAD", author = default_signature(repo),
  committer = default_signature(repo))
}
\arguments{
\item{repo}{The repository \code{object}.}

\item{message}{The commit message.}

\item{all}{Stage modified and deleted files. Files not added to
Git are not affected.}

\item{session}{Add sessionInfo to commit message. Default is
FALSE.}

\item{reference}{Name of the reference that will be updated to
point to this commit.}

\item{author}{Signature with author and author time of commit.}

\item{committer}{Signature with committer and commit time of commit.}
}
\value{
\code{\linkS4class{git_commit}} object
}
\description{
Commit
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")
}
}
\keyword{methods}

