% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/remote.r
\docType{methods}
\name{remotes}
\alias{remotes}
\alias{remotes,git_repository-method}
\title{Get the configured remotes for a repo}
\usage{
remotes(repo)

\S4method{remotes}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository to get remotes from}
}
\value{
Character vector with remotes
}
\description{
Get the configured remotes for a repo
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Add a remote
remote_add(repo, "playground", "https://example.org/git2r/playground")
remotes(repo)
remote_url(repo, "playground")

## Rename a remote
remote_rename(repo, "playground", "foobar")
remotes(repo)
remote_url(repo, "foobar")

## Remove a remote
remote_remove(repo, "foobar")
remotes(repo)
}
}
\keyword{methods}

