% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gist_auth.R
\name{gist_auth}
\alias{gist_auth}
\title{Authorize with GitHub.}
\usage{
gist_auth(app = gistr_app, reauth = FALSE)
}
\arguments{
\item{app}{An \code{\link[httr:oauth_app]{httr::oauth_app()}} for GitHub. The default uses an
application \code{gistr_oauth} created by Scott Chamberlain.}

\item{reauth}{(logical) Force re-authorization?}
}
\description{
This function is run automatically to allow gistr to access your GitHub
account.
}
\details{
There are two ways to authorise gistr to work with your GitHub account:
\itemize{
\item Generate a personal access token with the gist scope selected, and set it
as the \code{GITHUB_PAT} environment variable per session using \code{Sys.setenv}
or across sessions by adding it to your \code{.Renviron} file or similar.
See
https://help.github.com/articles/creating-an-access-token-for-command-line-use
for help
\item Interactively login into your GitHub account and authorise with OAuth.
}

Using \code{GITHUB_PAT} is recommended.
}
\examples{
\dontrun{
gist_auth()
}
}
