% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_coastallines.R
\name{gisco_get_coastallines}
\alias{gisco_get_coastallines}
\title{Get GISCO coastlines \code{sf} polygons}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}
}
\usage{
gisco_get_coastallines(
  year = "2016",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "20"
)
}
\arguments{
\item{year}{Release year. One of "2006", "2010", "2013" or "2016"}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
.geojson file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the geospatial data. One of
\itemize{
\item "60": 1:60million
\item "20": 1:20million
\item "10": 1:10million
\item "03": 1:3million
\item "01": 1:1million
}}
}
\value{
A \code{sf} \code{POLYGON} object.
}
\description{
Downloads worldwide coastlines
}
\note{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.

For a complete list of files available check \link{gisco_db}.
}

\examples{
coast <- gisco_get_coastallines()

library(ggplot2)

ggplot(coast) +
  geom_sf(color = "#1278AB", fill = "#FDFBEA") +
  # Zoom on Caribe
  coord_sf(
    xlim = c(-99, -49),
    ylim = c(4, 30)
  ) +
  theme_minimal() +
  theme(panel.background = element_rect(fill = "#C7E7FB", color = "black"))
}
\seealso{
\link{gisco_coastallines}

Other political: 
\code{\link{gisco_bulk_download}()},
\code{\link{gisco_get_countries}()},
\code{\link{gisco_get_lau}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_postalcodes}()},
\code{\link{gisco_get_units}()},
\code{\link{gisco_get_urban_audit}()}
}
\concept{political}
