% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettify.R
\name{get_dict_features}
\alias{get_dict_features}
\title{Get dictionary features}
\usage{
get_dict_features(
  dict = c("ipa", "unidic17", "unidic26", "unidic29", "cc-cedict", "ko-dic", "naist11",
    "sudachi")
)
}
\arguments{
\item{dict}{Character scalar; one of "ipa", "unidic17", "unidic26", "unidic29",
"cc-cedict", "ko-dic", "naist11", or "sudachi".}
}
\value{
A character vector.
}
\description{
Returns names of dictionary features.
Currently supports "unidic17" (2.1.2 src schema), "unidic26" (2.1.2 bin schema),
"unidic29" (schema used in 2.2.0, 2.3.0), "cc-cedict", "ko-dic" (mecab-ko-dic),
"naist11", "sudachi", and "ipa".
}
\examples{
get_dict_features("ipa")
}
\seealso{
See also
\href{https://github.com/ueda-keisuke/CC-CEDICT-MeCab}{'CC-CEDICT-MeCab'}
and \href{https://bitbucket.org/eunjeon/mecab-ko-dic/src/master/}{'mecab-ko-dic'}.
}
