% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibasa-deprecated.R
\name{gbs_tokenize}
\alias{gbs_tokenize}
\title{Tokenize sentences using 'MeCab'}
\usage{
gbs_tokenize(
  x,
  sys_dic = "",
  user_dic = "",
  split = FALSE,
  partial = FALSE,
  mode = c("parse", "wakati")
)
}
\arguments{
\item{x}{A data.frame like object or a character vector to be tokenized.}

\item{sys_dic}{Character scalar; path to the system dictionary for mecab.
Note that the system dictionary is expected to be compiled with UTF-8,
not Shift-JIS or other encodings.}

\item{user_dic}{Character scalar; path to the user dictionary for mecab.}

\item{split}{Logical. When passed as \code{TRUE}, the function internally splits the sentences
into sub-sentences using \code{stringi::stri_split_boudaries(type = "sentence")}.}

\item{partial}{Logical. When passed as \code{TRUE}, activates partial parsing mode.
To activate this feature, remember that all spaces at the start and end of
the input chunks are already squashed. In particular, trailing spaces
of chunks sometimes cause fatal errors.}

\item{mode}{Character scalar to switch output format.}
}
\value{
A tibble or a named list of tokens.
}
\description{
Tokenize sentences using 'MeCab'
}
