% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{ggplot2-scales-continuous}
\alias{ggplot2-scales-continuous}
\alias{scale_colour_ghibli_c}
\alias{scale_color_ghibli_c}
\alias{scale_fill_ghibli_c}
\title{Continuous scales to use for ggplot2}
\usage{
scale_colour_ghibli_c(name, direction = 1, ...)

scale_color_ghibli_c(name, direction = 1, ...)

scale_fill_ghibli_c(name, direction = 1, ...)
}
\arguments{
\item{name}{Name of desired palette.}

\item{direction}{Either `1` or `-1`. If `-1` the palette will be reversed.}

\item{...}{Arguments to pass on to `ggplot2::scale_colour_gradientn()` or
`ggplot2::scale_fill_gradientn()`}
}
\value{
A `ScaleContinuous` object that can be added to a `ggplot` object
}
\description{
These functions provide the option to use ghibli colours inside continuous
palettes with the `ggplot2` package.
}
\details{
Available palettes are found in \code{\link[ghibli]{ghibli_palettes}}.
}
\examples{

if (require('ggplot2')) {

  ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width, colour = Petal.Length)) +
    geom_point() +
    scale_colour_ghibli_c("PonyoMedium")
}

}
