% Generated by roxygen2 (4.0.2): do not edit by hand
\name{handle_resize}
\alias{handle_resize}
\alias{plot_height}
\alias{plot_width}
\title{Handlers and interactive inputs for plot sizing.}
\usage{
handle_resize(vis, on_resize)

plot_width(vis)

plot_height(vis)
}
\arguments{
\item{vis}{Visualisation to listen to.}

\item{on_resize}{Callback function with arguments:
\describe{
 \item{width,height}{Width and height in pixels}
 \item{padding}{A named list of four components giving the padding in
   each direction}
 \item{session}{The session, used to communicate with the browser}
}}
}
\description{
Handlers and interactive inputs for plot sizing.
}
\examples{
# This example just prints out the current dimensions to the console
mtcars \%>\% ggvis(~mpg, ~wt) \%>\%
  layer_points() \%>\%
  handle_resize(function(width, height, ...) cat(width, "x", height, "\\n"))

# Use plot_width() and plot_height() to dynamically get the plot size
# inside the plot.
mtcars \%>\% ggvis(~mpg, ~wt) \%>\% layer_text(text := plot_width())
mtcars \%>\% ggvis(~mpg, ~wt) \%>\% layer_text(text := plot_height())
}

