% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dplyr-ggvis}
\alias{arrange_.ggvis}
\alias{arrange_.reactive}
\alias{dplyr-ggvis}
\alias{filter_.ggvis}
\alias{filter_.reactive}
\alias{group_by_.ggvis}
\alias{group_by_.reactive}
\alias{groups.ggvis}
\alias{groups.reactive}
\alias{mutate_.ggvis}
\alias{mutate_.reactive}
\alias{select_.ggvis}
\alias{select_.reactive}
\alias{summarise_.ggvis}
\alias{summarise_.reactive}
\alias{ungroup.ggvis}
\alias{ungroup.reactive}
\title{Dplyr verbs for ggvis.}
\usage{
groups.ggvis(x)

group_by_.ggvis(.data, ..., .dots, add = FALSE)

ungroup.ggvis(x)

summarise_.ggvis(.data, ..., .dots)

mutate_.ggvis(.data, ..., .dots)

arrange_.ggvis(.data, ..., .dots)

select_.ggvis(.data, ..., .dots)

filter_.ggvis(.data, ..., .dots)

groups.reactive(x)

ungroup.reactive(x)

group_by_.reactive(.data, ..., .dots, add = FALSE)

summarise_.reactive(.data, ..., .dots)

mutate_.reactive(.data, ..., .dots)

arrange_.reactive(.data, ..., .dots)

select_.reactive(.data, ..., .dots)

filter_.reactive(.data, ..., .dots)
}
\description{
Applying a dplyr verb to a ggvis object creates a reactive transformation:
whenever the underlying data changes the transformation will be recomputed.
}
\section{Non-standard evaluation}{

Both dplyr and shiny do non-standard evaluation, so to help each package
figure out when it should evaluate its code, reactive components in
these functions must be wrapped in \code{eval()}.
}
\examples{
library(dplyr)
base <- mtcars \%>\% ggvis(~mpg, ~cyl) \%>\% layer_points()
base \%>\% group_by(cyl) \%>\% summarise(mpg = mean(mpg)) \%>\%
  layer_points(fill := "red", size := 100)

base \%>\% filter(mpg > 25) \%>\% layer_points(fill := "red")

base \%>\% mutate(cyl = jitter(cyl)) \%>\% layer_points(fill := "red")

\dontrun{
# Dynamically restrict range using filter
mtcars \%>\% ggvis(~disp, ~mpg) \%>\%
   filter(cyl > eval(input_slider(0, 10))) \%>\%
   layer_points()

# Dynamically compute box-cox transformation with mutate
bc <- function(x, lambda) {
  if (abs(lambda) < 1e-6) log(x) else (x ^ lambda - 1) / lambda
}
bc_slider <- input_slider(-2, 2, 1, step = 0.1)
mtcars \%>\%
 ggvis(~disp, ~mpg) \%>\%
 mutate(disp = bc(disp, eval(bc_slider))) \%>\%
 layer_points()
}
}
\keyword{internal}

