% Generated by roxygen2 (4.0.2): do not edit by hand
\name{scale_numeric}
\alias{scale_numeric}
\title{Add a numeric scale to a ggvis object.}
\usage{
scale_numeric(vis, property, domain = NULL, range = NULL, reverse = NULL,
  round = NULL, trans = NULL, clamp = NULL, exponent = NULL,
  nice = NULL, zero = NULL, expand = NULL, name = property,
  label = NULL, override = NULL)
}
\arguments{
\item{vis}{A ggvis object.}

\item{property}{The name of a visual property, such as "x", "y", "fill",
"stroke". Note both x and x2 use the "x" scale (similarly for y and y2).
fillOpacity, opacity and strokeOpacity use the "opacity" scale.}

\item{domain}{The domain of the scale, representing the set of data values.
For ordinal scales, a character vector; for quantitative scales, a numeric
vector of length two. Either value (but not both) may be NA, in which
case \code{domainMin} or \code{domainMax} is set. For dynamic scales, this
can also be a reactive which returns the appropriate type of vector.}

\item{range}{The range of the scale, representing the set of visual values.
For numeric values, the range can take the form of a two-element array with
minimum and maximum values. For ordinal data, the range may by an array of
desired output values, which are mapped to elements in the specified
domain. The following range literals are also available: "width", "height",
"shapes", "category10", "category20".}

\item{reverse}{If true, flips the scale range.}

\item{round}{If true, rounds numeric output values to integers. This can be
helpful for snapping to the pixel grid.}

\item{trans}{A scale transformation: one of "linear", "log", "pow", "sqrt",
"quantile", "quantize", "threshold". Default is "linear".}

\item{clamp}{If \code{TRUE}, values that exceed the data domain are clamped
to either the minimum or maximum range value. Default is \code{FALSE}.}

\item{exponent}{Sets the exponent of the scale transformation. For pow
transform only.}

\item{nice}{If \code{TRUE}, modifies the scale domain to use a more
human-friendly number range (e.g., 7 instead of 6.96). Default is
\code{FALSE}.}

\item{zero}{If \code{TRUE}, ensures that a zero baseline value is included
in the scale domain. This option is ignored for non-quantitative scales.
Default is \code{FALSE}.}

\item{expand}{A multiplier for how much the scale should be expanded beyond
the domain of the data. For example, if the data goes from 10 to 110, and
\code{expand} is 0.05, then the resulting domain of the scale is 5 to 115.
Set to 0 and use \code{nice=FALSE} if you want exact control over the
domain. If left \code{NULL}, behavior will depend on the scale type. For
positional scales (x and y), \code{expand} will default to 0.05. For other
scales, it will default to 0.}

\item{name}{Name of the scale, such as "x", "y", "fill", etc. Can also be an
arbitrary name like "foo".}

\item{label}{Label for the scale. Used for axis or legend titles.}

\item{override}{Should the domain specified by this ggvis_scale object
override other ggvis_scale objects for the same scale? Useful when domain is
manually specified. For example, by default, the domain of the scale
will contain the range of the data, but when this is TRUE, the specified
domain will override, and the domain can be smaller than the range of the
data. If \code{FALSE}, the \code{domain} will not behave this way. If
left \code{NULL}, then it will be treated as \code{TRUE} whenever
\code{domain} is non-NULL.}
}
\description{
A numeric (quantitative) scale controls the mapping of continuous variables
to visual properties.
}
\details{
The default values for most of the arguments is NULL. When the plot is
created, these NULL values will be replaced with default values, as indicated
below.
}
\examples{
p <- mtcars \%>\% ggvis(~wt, ~mpg, fill = ~hp) \%>\% layer_points()

p \%>\% scale_numeric("y")

p \%>\% scale_numeric("y", trans = "pow", exponent = 0.5)

p \%>\% scale_numeric("y", trans = "log")

# Can control other properties other than x and y
p \%>\% scale_numeric("fill", domain = c(0, 120), clamp = TRUE)

# Set range of data from 0 to 3
p \%>\% scale_numeric("x", domain = c(0, 3), clamp = TRUE, expand = 0,
                     nice = FALSE)

# Lower bound is set to lower limit of data, upper bound set to 3.
p \%>\% scale_numeric("x", domain = c(NA, 3), clamp = TRUE, nice = FALSE)
}
\seealso{
\code{\link{scales}}, \code{\link{scale_ordinal}},
  \url{https://github.com/trifacta/vega/wiki/Scales#quantitative-scale-properties}

Other scales: \code{\link{scale_datetime}};
  \code{\link{scale_logical}}, \code{\link{scale_nominal}},
  \code{\link{scale_ordinal}}
}

