% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggvenn.R
\name{ggvenn}
\alias{ggvenn}
\title{Plot venn diagram as an independent function. It supports both data frame and list as input.}
\usage{
ggvenn(
  data,
  columns = NULL,
  show_elements = FALSE,
  show_percentage = TRUE,
  digits = 1,
  fill_color = c("blue", "yellow", "green", "red"),
  fill_alpha = 0.5,
  stroke_color = "black",
  stroke_alpha = 1,
  stroke_size = 1,
  stroke_linetype = "solid",
  set_name_color = "black",
  set_name_size = 6,
  text_color = "black",
  text_size = 4,
  label_sep = ","
)
}
\arguments{
\item{data}{A data.frame or a list as input data.}

\item{columns}{A character vector use as index to select columns/elements.}

\item{show_elements}{Show set elements instead of count/percentage.}

\item{show_percentage}{Show percentage for each set.}

\item{digits}{The desired number of digits after the decimal point}

\item{fill_color}{Filling colors in circles.}

\item{fill_alpha}{Transparency for filling circles.}

\item{stroke_color}{Stroke color for drawing circles.}

\item{stroke_alpha}{Transparency for drawing circles.}

\item{stroke_size}{Stroke size for drawing circles.}

\item{stroke_linetype}{Line type for drawing circles.}

\item{set_name_color}{Text color for set names.}

\item{set_name_size}{Text size for set names.}

\item{text_color}{Text color for intersect contents.}

\item{text_size}{Text size for intersect contents.}

\item{label_sep}{separator character for displaying elements.}
}
\value{
The ggplot object to print or save to file.
}
\description{
Plot venn diagram as an independent function. It supports both data frame and list as input.
}
\examples{
library(ggvenn)

# use list as input
a <- list(`Set 1` = c(1, 3, 5, 7),
          `Set 2` = c(1, 5, 9),
          `Set 3` = c(1, 2, 8),
          `Set 4` = c(6, 7))
ggvenn(a, c("Set 1", "Set 2"))
ggvenn(a, c("Set 1", "Set 2", "Set 3"))
ggvenn(a)

# use data.frame as input
d <- tibble(value   = c(1,     2,     3,     5,     6,     7,     8,     9),
            `Set 1` = c(TRUE,  FALSE, TRUE,  TRUE,  FALSE, TRUE,  FALSE, TRUE),
            `Set 2` = c(TRUE,  FALSE, FALSE, TRUE,  FALSE, FALSE, FALSE, TRUE),
            `Set 3` = c(TRUE,  TRUE,  FALSE, FALSE, FALSE, FALSE, TRUE,  TRUE),
            `Set 4` = c(FALSE, FALSE, FALSE, FALSE, TRUE,  TRUE,  FALSE, FALSE))
ggvenn(d, c("Set 1", "Set 2"))
ggvenn(d, c("Set 1", "Set 2", "Set 3"))
ggvenn(d)

# set fill color
ggvenn(d, c("Set 1", "Set 2"), fill_color = c("red", "blue"))

# hide percentage
ggvenn(d, c("Set 1", "Set 2"), show_percentage = FALSE)

# change precision of percentages
ggvenn(d, c("Set 1", "Set 2"), digits = 2)

# show elements instead of count/percentage
ggvenn(a, show_elements = TRUE)
ggvenn(d, show_elements = "value")
}
\seealso{
geom_venn
}
