% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tidy_movies}
\alias{tidy_movies}
\title{Tidy version of the movies dataset from the ggplot2 package}
\format{
a data frame with 50,000 rows and 10 columns
\itemize{
  \item title. The title of the movie.
  \item year. Year of release.
  \item budget. Total budget (if known) in US dollars.
  \item length. Length in minutes.
  \item rating. Average IMDB user rating.
  \item votes. Number of IMDB user who rated this movie.
  \item mpaa. MPAA rating
  \item Genres. List column with all genres the movie belongs to
  \item stars, percent_rating. The number of stars and the corresponding
    percentage of people rating the movie with this many stars.
}
}
\usage{
tidy_movies
}
\description{
The original \code{ggplot2movies::movies} dataset has 7 columns that
contain indicators if a movies belongs to a certain genre. In this version
the 7 columns are collapsed to a single list column to create a tidy
dataset. It also has information on only 5,000 movies to reduce the size
of the dataset. Furthermore each star rating is in its on row.
}
\examples{
dim(tidy_movies)
head(tidy_movies)

}
\keyword{datasets}
