% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstatsplot-package.R
\docType{package}
\name{ggstatsplot-package}
\alias{ggstatsplot-package}
\alias{_PACKAGE}
\alias{ggstatsplot}
\title{ggstatsplot: 'ggplot2' Based Plots with Statistical Details}
\description{
\code{{ggstatsplot}} is an extension of \code{{ggplot2}} package. It creates
graphics with details from statistical tests included in the plots
themselves. It provides an easier \code{API} to generate information-rich plots
for statistical analysis of continuous (violin plots, scatterplots,
histograms, dot plots, dot-and-whisker plots) or categorical (pie and bar
charts) data. Currently, it supports the most common types of statistical
tests: parametric, nonparametric, robust, and Bayesian versions of
\emph{t}-test/ANOVA, correlation analyses, contingency table analysis,
meta-analysis, and regression analyses.
}
\details{
\code{ggstatsplot}

The main functions are:
\itemize{
\item \code{ggbetweenstats()} function to produce information-rich comparison plot
\emph{between} different groups or conditions with \code{{ggplot2}} and details from
the statistical tests in the subtitle.
\item \code{ggwithinstats()} function to produce information-rich comparison plot
\emph{within} different groups or conditions with \code{{ggplot2}} and details from
the statistical tests in the subtitle.
\item \code{ggscatterstats()} function to produce \code{{ggplot2}} scatterplots along
with a marginal distribution plots from \code{{ggside}} package and details from
the statistical tests in the subtitle.
\item \code{ggpiestats()} function to produce pie chart with details from the
statistical tests in the subtitle.
\item \code{ggbarstats()} function to produce stacked bar chart with details from
the statistical tests in the subtitle.
\item \code{gghistostats()} function to produce histogram for a single variable with
results from one sample test displayed in the subtitle.
\item \code{ggdotplotstats()} function to produce Cleveland-style dot plots/charts
for a single variable with labels and results from one sample test
displayed in the subtitle.
\item \code{ggcorrmat()} function to visualize the correlation matrix.
\item \code{ggcoefstats()} function to visualize results from regression analyses.
\item \code{combine_plots()} helper function to combine multiple \code{{ggstatsplot}}
plots using \code{patchwork::wrap_plots()}.
}

For more documentation, see the dedicated
\href{https://indrajeetpatil.github.io/ggstatsplot/}{Website}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://indrajeetpatil.github.io/ggstatsplot/}
  \item \url{https://github.com/IndrajeetPatil/ggstatsplot}
  \item Report bugs at \url{https://github.com/IndrajeetPatil/ggstatsplot/issues}
}

}
\author{
\strong{Maintainer}: Indrajeet Patil \email{patilindrajeet.science@gmail.com} (\href{https://orcid.org/0000-0003-1995-6531}{ORCID}) (@patilindrajeets) [copyright holder]

}
